/*
 * Decompiled with CFR 0.152.
 */
package io.gitlab.jfronny.commons.concurrent.scoped;

import io.gitlab.jfronny.commons.concurrent.scoped.IScopedValue;
import io.gitlab.jfronny.commons.concurrent.scoped.ThreadLocalScopedValue;
import io.gitlab.jfronny.commons.throwable.Coerce;
import java.lang.ref.WeakReference;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.Supplier;

public class MappingScopedValue<T, R>
implements IScopedValue<R> {
    private final IScopedValue<T> delegate;
    private final Function<? super T, ? extends R> mapper;
    private final ThreadLocalScopedValue<R> override = new ThreadLocalScopedValue();
    private final Object lock = new Object();
    private Mapping<T, R> lastMapping = null;

    public MappingScopedValue(IScopedValue<T> delegate, Function<? super T, ? extends R> mapper) {
        this.delegate = delegate;
        this.mapper = mapper;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private R applyMapping(T value) {
        Mapping<T, R> m = this.lastMapping;
        if (m != null && m.from.refersTo(value)) {
            return m.to;
        }
        Object object = this.lock;
        synchronized (object) {
            m = this.lastMapping;
            if (m != null && m.from.refersTo(value)) {
                return m.to;
            }
            R mapped = this.mapper.apply(value);
            this.lastMapping = new Mapping<T, R>(new WeakReference<T>(value), mapped);
            return mapped;
        }
    }

    @Override
    public <R1> R1 callWith(R value, Callable<? extends R1> op) throws Exception {
        return this.override.callWith((R1)value, op);
    }

    @Override
    public <R1> R1 getWith(R value, Supplier<? extends R1> op) {
        return this.override.getWith((R1)value, op);
    }

    @Override
    public void runWith(R value, Runnable op) {
        this.override.runWith(value, op);
    }

    @Override
    public R get() throws NoSuchElementException {
        return (R)this.override.orElse(() -> this.applyMapping(this.delegate.get()));
    }

    @Override
    public Optional<R> getOptional() {
        return this.override.getOptional().or(() -> this.delegate.getOptional().map(this::applyMapping));
    }

    @Override
    public boolean isBound() {
        return this.override.isBound() || this.delegate.isBound();
    }

    @Override
    public R orElse(R other) {
        return (R)this.override.orElse(() -> this.delegate.getOptional().map(this::applyMapping).orElse(other));
    }

    @Override
    public R orElse(Supplier<? extends R> otherSupplier) {
        return (R)this.override.orElse(() -> this.delegate.getOptional().map(this::applyMapping).orElseGet(otherSupplier));
    }

    @Override
    public <X extends Throwable> R orElseThrow(Supplier<? extends X> exceptionSupplier) throws X {
        return (R)this.override.orElse(Coerce.supplier(() -> this.applyMapping(this.delegate.orElseThrow(exceptionSupplier))).assumeSafe());
    }

    private record Mapping<T, R>(WeakReference<T> from, R to) {
    }
}

